function [mpl1,mpl2]=bspexpserv_kk(n,t,delta,g0,r,set,knots,f,pw)
% MATLAB function for boostraped estimates of survival probabilites from kin-cohort
% family data
% For definition of the input arguments t,delta,g0,rknots,f,pw see the function 
% pexpsurv_kk
%
% ADDITIONAL INPUT ARGUMENTS (all vectors should be column vector)
%	n=number of bootstrap samples
%  set = vector of family identification for the relatives
% 
% OUTPUT ARGUMENTS
%  mp1 = n by (K+1) matrix of survial probabilities for non-carriers (K=number of knots).
%  mp2 = n by (K+1) matrix of survial probabilities for carriers (K=number of knots).

          

m=length(t);
index = (1:m)';
id = unique(set);
nfamily = length(id);

mpl1 = zeros(n,length(knots));
mpl2 = zeros(n,length(knots));



x = cell(nfamily);

for  i=1:length(id)
	  x{i} = (index(set==id(i)))';
end
idn = 1:nfamily;
i=1;
   
while i<=n
   i
   s=sample(nfamily,(ones(nfamily,1)./nfamily));
   index_s=[x{s}]';
   
   t_s=t(index_s);
   delta_s=delta(index_s);
   g0_s=g0(index_s);
   r_s =r(index_s);
   set_s=set(index_s);
   pw_s=pw(index_s);
   
   [s, l, conv] = pexpsurv_kk(t_s,delta_s,g0_s,r_s,knots,f,pw_s);

   mpl1(i,:) = (1-s(:,1))'; 
   mpl2(i,:) = (1-s(:,2))'; 
   i=i+1;
end

