/*
   APA_BrCa_example.sas                                                       12/01/10

   a sample sas program which obtains absolute risk of breast cancer for Asian-Pacific
   American Women as well as 95% confidence intervals by involking the SAS macro
   APA_BrCa_RAM

   This sample sas program involves 2 steps:

   Step1:  Initially inputing from an ascii/flat file  "APA_RR.fil".  This file
           contains race, relative risk and projection age variables. Upon the
           conclusion of Step1, a sas file  "APA_BrCa_In"  is created to be used for
           input in Step2 for the sas macro  "APA_BrCa_RAM".

           In addition, a listing of each women's relevant variables on the
           sas file  "APA_BrCa_In"  is provided.

   Step2: "Including" the sas macro  "APA_BrCa_RAM"  which is used for Asian-Pacific-
           American Breast Cancer abs risk projection.  Once this macro is "included",
           this program involkes it to project for Asian-Pacific-American breast cancer
           absolute risk by reading the sas file  "APA_BrCa_In".

           A listing of the resulting sas file  "APA_BrCaOut"  which includes the
           projected absolute risk, se of abs risk and 95% confidence interval as
           well as the relevant variables are produced at the completion of this program.
*/

title1 'APA_BrCa_example.sas:  Absolute risk projection of BrCa for Asian-Pacific-American women';

options nocenter ls=100  ps=9999 pageno=1 ;
options FORMCHAR="|----|+|---+=|-/\<>*";

*** Step1       Reads the sample input ascii/flat data file  "APA_RR.fil"  and saves it
                as a sas file  "APA_BrCa_In"  for input to the sas macro  "APA_BrCa_RAM".
                print the relevant variables for each Asian-Pacific-American women on the file;

data    APA_BrCa_In;                                  *** sas file needed for input
                                                          to the sas macro;

        infile  "APA_RR.fil"  firstobs=9;             *** input ascii/flat file  "APA_RR.fil"
                                                          firstobs=9  skips first 8 header
                                                          records on input file  "APA_RR.fil";
        input   IDD
                Currn_Age
                Projtn_Age
                Num_Biops
                AgeMenarche
                AgeFstLive
                Num_Rels
                HP
                Race;

        if      (Race eq 1) then  charRace = "  Ch";
        else if (Race eq 2) then  charRace = "  Ja";
        else if (Race eq 3) then  charRace = "  Fp";
        else if (Race eq 4) then  charRace = "  Hw";
        else if (Race eq 5) then  charRace = "  oP";
        else if (Race eq 6) then  charRace = "  oA";
        else                      charRace = "  ??";
run;


***     proc    print  data=APA_BrCa_In;                    *** print the input file;
***     ID      IDD;
***     var     Currn_Age
        Projtn_Age
        Num_Biops
        AgeMenarche
        AgeFstLive
        Num_Rels
        HP
        Race
        charRace;

***     title3 "Sample relative risk covaraites and projection ages for absolute risk projections";
***     run;

title2;



*** Step 2      Involking the sas macro APA_BrCa_RAM to perform the BrCa projections.

                The temporary sas input  file is set to  "APA_BrCa_In" in this program.
                The temporary sas output file is set to  "APA_BrCaOut" in this program.

                Input variables to the sas macro  APA_BrCa_RAM and output variables by the
                sas macro as well as their corresponding sas macro variables are listed below:

                macro                                                        user defined
                variables                                                    sas variables

                IDD         points to the user defined sas  input variable   IDD
                T1          points to the user defined sas  input variable   Currn_Age
                T2          points to the user defined sas  input variable   Projtn_Age
                NBiops      points to the user defined sas  input variable   Num_Biops
                AgeMen      points to the user defined sas  input variable   AgeMenarche
                AgeFst      points to the user defined sas  input variable   AgeFstLive
                NumRel      points to the user defined sas  input variable   Num_Rels
                HyprPlas    points to the user defined sas  input variable   HP
                Race        points to the user defined sas  input variable   Race

                RelRsk      points to the user defined sas output variable   ReltvRisk,
                AbsRsk      points to the user defined sas output variable   Absolute_Risk,
                se_AbsRsk   points to the user defined sas output variable   SE_AbsolutRsk,
                Lo_95CI     points to the user defined sas output variable   Lower_95CI and
                Hi_95CI     points to the user defined sas output variable   Highr_95CI

                The user defined sas variables  ReltvRisk, Absolute_Risk ... Highr_95CI
                are added to the output sas file  "APA_BrCaOut".

                The output sas file  "APA_BrCaOut"  will also contain all the relevant
                relative risk variables required by the sas macro  "APA_BrCa_RAM";



%include  "APA_BrCa_RAM";             *** Including  APA_BrCa_RAM  SAS macro here.
                                          If you want the SAS macro to be in-line with
                                          this program, copy  the file  APA_BrCa_RAM  here;

            *** Required
                Macro          pointing      SAS file name or
                parameters     to            SAS variable name;

%APA_BrCa_RAM  (In_File        =             APA_BrCa_In  ,
                Out_File       =             APA_BrCaOut  ,

                IDD            =             IDD          ,

                T1             =             Currn_Age    ,
                T2             =             Projtn_Age   ,

                NBiops         =             Num_Biops    ,
                AgeMen         =             AgeMenarche  ,
                AgeFst         =             AgeFstLive   ,
                NumRel         =             Num_Rels     ,

                HyprPlas       =             HP           ,

                Race           =             Race         ,

                RelRsk         =             ReltvRisk    ,
                AbsRsk         =             Absolute_Risk,
                se_AbsRsk      =             SE_AbsolutRsk,
                Lo_95CI        =             Lower_95CI   ,
                Hi_95CI        =             Upper_95CI   ,

                Error_Ind      =             Error_Ind    );



data    APA_BrCaOut;
set     APA_BrCaOut;

        if      (Race eq 1) then  charRace = " Ch";
        else if (Race eq 2) then  charRace = " Ja";
        else if (Race eq 3) then  charRace = " Fp";
        else if (Race eq 4) then  charRace = " Hw";
        else if (Race eq 5) then  charRace = " oP";
        else if (Race eq 6) then  charRace = " oA";
        else                      charRace = " ??";
run;


proc    print  data=APA_BrCaOut;                        *** print the output sas file;
id      IDD;
var     Num_Biops
        AgeMenarche
        AgeFstLive
        Num_Rels
        HP
        Currn_Age
        Projtn_Age
        ReltvRisk
        Absolute_Risk
        SE_AbsolutRsk
        Lower_95CI
        Upper_95CI
        Error_Ind
        Race
        charRace;

title3 "APA_BrCaOut:  SAS file with Asian-Pacific-American Women RR covariates,"
       "projected Absolute Risk and 95% CI";
run;
