*** Short example on the use of the SAS macro  "BrCa_MD_RAM"  consisting of 3 steps.

    Step 1 is the creation and listing of a temporary sas input system file (ExampleIn)
           from a raw file (Sample.in) consisting of 26 hypothetical women's
           relative risk covariate information.

    Step 2 is the involking of the sas macro  BrCa_MD_RAM  to perform risk projection.

    Step 3 is a simple post processing step.  The post processing is the listing of the
           temporary sas sytem file (Out_File) which contains the women's
           relative risk covariate information as well as projected absolute risk.;


*** Step 1 Input raw relative risk covariate file  "Sample.in"  and create a temporary
           sas system file with name of  "ExampleIn"  and list the file contents.
           The temporary sas file  "ExampleIn"  is used in step 2 for input to the sas
           macro  BrCa_MD_RAM  which projects for absolute risk of BrCa;

option   nocenter  ls=93  ps=61  notes;
OPTIONS  FORMCHAR="|----|+|---+=|-/\<>*";

title1  'BC_MD_example.sas, example sas program using sas macro  BrCa_MD_RAM';

data    ExampleIn;             *** name of the sas system file which the macro parameter
                                      &In_File  should point to upon macro invocation;

        infile 'Sample.In';                  *** name of the raw RR covariate input file;

            *** SAS variable names;
        input   InitalAge
                ProjtnAge

                PerCent_Den
                Num_Rels
                NBiop
                AgeFstLive
                Body_Weight;

                Rec_Num = _n_;

run;


***      list the contents of the temporary sas sytem file  ExampleIn;
proc     print  data=ExampleIn;
id       Rec_Num;
var      InitalAge  ProjtnAge  PerCent_Den  Num_Rels  NBiop  AgeFstLive  Body_Weight;

title3  'Listing of the temporary input sas system file      "ExampleIn"';
title4  'Created from the raw relative risk covariate file   "Sample.In"';
run;


*** Step 2    Involking the sas macro BrCa_RAM to perform the BrCa projections.

              The temporary sas input  file is set to   "ExampleIn".
              The temporary sas output file is set to   "ExampleOut".

              The macro parameters  T1, T2, PDensty, N_Rels, N_Biop, Age1st and
              BdyWght points to their corresponding sas variables on the sas file
              "ExampleIn",  namely InitalAge, ProjtnAge, PerCent_Den, Num_Rels,
              NBiop, HP, AgeFstLive and Body_Weight respectively.

              The macro parameter AbsRsk points to the sas variable Absolute_Risk
              which will be added to the output sas file  "ExampleOut".  The output
              sas file will also contain all the variables on the input sas file.;


%include     "BrCa_MD_RAM";               *** inclusion of the SAS macro BrCa_MD_RAM;


***           Macro          pointing      SAS file name or
              parameter      to            SAS variable name;

%BrCa_MD_RAM
             (In_File        =             ExampleIn    ,
              Out_File       =             ExampleOut   ,

              T1             =             InitalAge    ,
              T2             =             ProjtnAge    ,

              PDensty        =             PerCent_Den  ,
              N_Rels         =             Num_Rels     ,
              N_Biop         =             NBiop        ,
              Age1st         =             AgeFstLive   ,
              BdyWght        =             Body_Weight  ,

              AbsRsk         =             Absolute_Risk);



*** Step 3    List the contents of the temporary output sas system file  "ExampleOut"
              which contains the projected absolute risk as well as the relative risk
              covariate values.  Note that any further processing requiring the
              projected absolute risk, must be performed on the output sas system file;

data  ExampleOut;                  *** output file from macro, defined by pointing the;
set   ExampleOut;                  *** macro parameter  &Out_File  to  "ExampleOut";

      file print;

      if (_N_ eq 1) then do;
         put " Record                  %    #     #  Age    Body"
             "  (1-ar)RR  (1-ar)RR              Pattrn";
         put "      #    T1    T2   Dens  Rel  Biop  1st    Wght"
             "    Age<50    Age>50      AbsRsk       #";
         put " ";
      end;

      *** all variables below take on their SAS variable names, not their macro names;
      *** see SAS variable names defined in Step 1;
      if (Rec_Num le 100) then  put

          Rec_Num              7.0
          InitalAge            6.1
          ProjtnAge            6.1

          PerCent_Den          7.1
          Num_Rels             5.0
          NBiop                6.0
          AgeFstLive           5.0
          Body_Weight          8.1

          One_AR_RR1          10.4
          One_AR_RR2          10.4
          Absolute_Risk       12.6
          PattrnNumber         8.0;

title3   "Listing of the first 100 records in temporary output sas system file  ExampleOut";
title4   "Further analysis depending on the projected abs risk must be performed using the";
title5   "output sas system file which is invoked by the sas macro parameter  'Out_File'";
title6   " ";
run;

