/*
    AARP_PLCO_BrCa_Model7_Template.sas                                                     12/27/2011

    Short example of creating a temporary sas system file  (BrCaFil) for input to the
    sas macros:

       "AARP_PLCO_BrCa_RAM_Model7"      (valid model)

    Step 1 reads in women's ID, current age, projection age and Model 6 relative risk covariates from
           a flat file (ascii file)  BrCaFlat7.in  and creates a temporary sas file  BrCaFil.

    Step 2 is the involking of the sas macro  AARP_PLCO_BrCa_RAM_Model7  to perform
           risk projection using the temporary sas sytem file  BrCaFil as input.

    Step 3 is a simple post processing step.  The post processing is the listing of the
           temporary sas sytem file (BrCaFil) which contains the women's
           relative risk covariate information as well as appending the
           projected absolute risk based on relative risk model 6 and abs risk projection model 7;
*/


option   nocenter  ls=122  ps=44  notes;
OPTIONS  FORMCHAR="|----|+|---+=|-/\<>*";


*** Step 1 Input raw relative risk covariate file  "BrCaFlat7.in"  and create a temporary
           sas system file with an arbitrary name say  "BrCaFil".
           SAS file "BrCaFil" used as input in step 2 sas macro AARP_PLCO_BrCa_RAM_Model7
           which projects for abs risk of BrCa based on relative risk Model 6

           if one already has a SAS file with the needed covariate information for
           Model 7 this step can be ignored and one can skip to Steps 2;

data    BrCaFil  ;                *** name of the sas system file which the macro parameter
                                      &SAS_File  should point to upon macro invocation.
                                      any arbitrary sas name can be used;

        infile 'BrCaFlat7.in'  FIRSTOBS=12;    *** name of the raw  RR  covariate input file (flat file)
                                                   any arbitrary sas name can be used

                                                   FIRSTOBS=12  skips the first  11  records of file
                                                   header on input file  'BrCaFlat7.in';

                *** SAS variable names for RR covariates.  any arbitrary sas name can be used

                    NOTE that all rr covariates  MUST BE RECODED  from their original values to
                         the integer value risk levels of  0,1,2...  used in the model;

            input   subject_ID

                    entryage
                    exitage_b

                    BMI4_cats

                    Age_1stChild_Brth
                    Nulliparous_Ind

                    Age_MenoPause
                    Pre_MenoPause_Ind

                    EPTDur_HRT
                    Other_HRT

                    FHbreast_Model
                    BBD_Model

                    ALC_Model

                    Race;

            label subject_ID = "Unique ID number of woman.";
run;



*** Step 2    Involking the sas macro AARP_PLCO_BrCa_RAM_Model7 to perform the BrCa projections.

              The temporary sas file is set to   "BrCaFil".

              The macro parameter  AbsRsk  points to the sas variable Absolute_Risk_Model7
              which will be appended to the sas file  "BrCaFil";


*** Breast Cancer Absolute Risk Projection sample program based on AARP/PLCO BrCa Rel Risk Model 6;
title1  'AARP_PLCO_BrCa_Model7_Template.sas, Sample sas program using sas macro  AARP_PLCO_BrCa_RAM_Model7';


%include     "AARP_PLCO_BrCa_RAM_Model7";          *** inclusion of the SAS macro
                                                        AAPR_PLCO_BrCa_RAM_Model7;

***                         Macro          pointing     SAS file name or
                            parameter      to           SAS variable name;

%AARP_PLCO_BrCa_RAM_Model7 (SAS_File                  = BrCaFil,

                            Woman_ID                  = Subject_ID,

                            T1                        = entryage,
                            T2                        = exitage_b,

                            AgeMeno                   = Age_MenoPause,
                            PreMeno                   = Pre_MenoPause_Ind,

                            EPTx_Model                = EPTDur_HRT,
                            Other_Horm                = Other_HRT,

                            BBD_Model                 = BBD_Model,

                            Age_1stChild_Brth         = Age_1stChild_Brth,
                            NumChild_0                = Nulliparous_Ind,

                            FHbreast_Model            = FHbreast_Model,
                            ALC_Model                 = ALC_Model,
                            BMI_Model                 = BMI4_cats,

                            Race                      = Race,


                            CharRace                  = CharRace,

                            AbsRsk7                   = Absolute_Risk_Model7);



*** Step 3    List the contents of the temporary output sas system file  "BrCaFil"
              which contains the projected absolute risk as well as the relative risk
              covariate values.  Note that any further processing requiring the
              projected absolute risk, must be performed on the sas file "BrCaFil;


option   nocenter  ls=133  ps=60;***  nonotes;


data  BrCaFil;                    *** SAS file used by macro, defined by pointing the;
set   BrCaFil;                    *** macro parameter  &SAS_File  to  "BrCaFil";

      file print;

      if (_N_ eq 1) then do;
         put "                                   BodyMass     Age1st            Age of           Duratn            Family                          " /
             "                                      Index   LiveBrth              Meno           EP HRT           History    B9   Drnk    Absolute " /
             "                                   0=   <25   0= Nulli             Pause     Pre   0=Othr           BrCa or    Br   /day        Risk " /
             "                                   1=[25:30)    or <25   Nulli  0=  <=49    Meno    or 0y   Other    OvarCa    Dz   0= 0        BrCa " /
             "      ID  Currn  Projc             2=[30:35)  1= 25:29  parous  1= 50:54   Pause   1=<=9y     HRT    0=  no   0=n   1=<1     Model 7 " /
             "       #    Age    Age      Race   3=  >=35   2=  >=30  Indcat  2=  >=55  Indcat   2=> 9y  Indcat    1= yes   1=y   2= 1+         (%)" /;
      end;

      *** all variables below take on their SAS variable names, not their macro names;
      *** see SAS variable names defined in Step 8;
      if (SEQ_Num le 500) then  put

          subject_ID                  8.0

          entryage                    7.1
          exitage_b                   7.1

          Race                        3.0  "="
          CharRace                   $6.

          BMI4_cats                  11.0

          Age_1stChild_Brth          11.0
          Nulliparous_Ind             8.0

          Age_MenoPause              10.0
          Pre_MenoPause_Ind           8.0

          EPTDur_HRT                  9.0
          Other_HRT                   8.0

          FHbreast_Model             10.0
          BBD_Model                   6.0

          ALC_Model                   7.0

          Absolute_Risk_Model7       12.4;

      if (mod(_n_,2) eq 0) then put " ";

title3   "Listing of the first 500 records in temporary sas system file  BrCaFil";
title4   "Further analysis based on the projected abs risk must be performed using the";
title5   "sas system file  BrCaFil  as well as using the SAS variables in  BrCaFil";
title6   " ";
run;

***       proc contents  data=BrCaFil  VARNUM position;
***       title1  'AARP_PLCO_BrCa_Model7_Template.sas, Sample sas program using sas macro  AARP_PLCO_BrCa_RAM_Model7';
***       title3 "Breast cancer Relative Risk model 6,  Abs Risk Projection model 7";
***       run;
