/*
    AARP_PLCO_OvCa_Model3_Template.sas                                      10/01/2013

    Short example on the use of the SAS macro  "AARP_PLCO_OvCa_RAM_Model3"  consisting
    of 3 steps  (steps 1-3)

    Step 1 is the creation and listing of a temporary sas system file (OvCaFil)
           from a raw file (OvCaFlat2.in) consisting of hypothetical women's
           relative risk covariate information.

    OvCa Model 3 abs risk projection:

    Step 2 is the involking of the sas macro  AARP_PLCO_OvCa_RAM_Model3  to perform
           risk projection.

    Step 3 is a simple post processing step.  The post processing is the listing of the
           temporary sas sytem file  (OvCaFil)  which contains the women's original
           relative risk covariate information as well as the appending of the
           projected absolute risk based on model 3.;
*/


option   nocenter  ls=110  ps=9999  notes;
OPTIONS  FORMCHAR="|----|+|---+=|-/\<>*";


title1  'AARP_PLCO_OvCa_Model3_Template.sas, Sample sas program using sas macro  AARP_PLCO_OvCa_RAM_Model3';

/*  Ovarian Cancer Absolute Risk Projection sample program based on AARP/PLCO OvCa RR Model 2 */

*** Step 1 Input raw relative risk covariate file  "OvCaFlat3.in"  and create a temporary
           sas system file with an arbitrary name say  "OvCaFil".
           The sas file  "OvCaFil"  is used in step 2 for input to the sas
           macro  AARP_PLCO_OvCa_RAM_RAM_Model3  which projects for absolute risk of OvCa
           based on AARP/PLCO RR Model 2

           if one already has a SAS file with the needed covariate information for rr model 2,
           this step can be ignored and one can skip to Step 2;

data    OvCaFil;                              *** name of the sas system file which the macro parameter
                                                 &SAS_File  should point to upon macro invocation.
                                                  any arbitrary sas name can be used;

        infile 'OvCaFlat3.In'  FIRSTOBS=10;   *** name of the raw  RR covariate input file (flat file)
                                                  any arbitrary sas name can be used

                                                  FIRSTOBS=10 skips the first 9 records of file header on
                                                  input file  'OvCaFlat3.in';

                *** SAS variable names for Model 2  RR covariates
                    any arbitrary sas name can be used

                    NOTE that all rr covariates  MUST BE RECODED  from their original values to
                         the integer value risk levels of  0,1,2...  used in the model;

            input   subject_ID

                    entryage
                    exitage_o

                    Invrs_OC_Modl
                    Invrs_Parity_Modl
                    Horm_Model
                    FHbreast_Model

                    Race;

            label subject_ID = "Unique ID number of woman";
run;


*** Step 2    Involking the sas macro AARP_PLCO_OvCa_RAM_Model3 to perform the OvCa projections.

              The temporary sas file is set to   "OvCaFil".

              The macro parameter  AbsRsk  points to the sas variable Absolute_Risk_Model3
              which will be appended to the sas file  "OvCaFil";

%include     "AARP_PLCO_OvCa_RAM_Model3";           *** inclusion of the SAS macro
                                                        AAPR_PLCO_OvCa_RAM_Model3;

***                         Macro          pointing     SAS file name or
                            parameter      to           SAS variable name;

%AARP_PLCO_OvCa_RAM_Model3 (SAS_File                  = OvCaFil,

                            Woman_ID                  = Subject_ID,

                            T1                        = entryage,
                            T2                        = exitage_o,

                            Invrs_OC_Model            = Invrs_OC_Modl,
                            Invrs_Parity_Model        = Invrs_Parity_Modl,
                            Horm_Model                = Horm_Model,
                            FHbreast_Model            = FHbreast_Model,

                            Race                      = Race,
                            CharRace                  = CharRace,

                            AbsRsk                    = Absolute_Risk_Model3);



*** Step 3    List the contents of the temporary output sas system file  "OvCaFil"
              which contains the projected absolute risk as well as the relative risk
              covariate values.  Note that any further processing requiring the
              projected absolute risk, must be performed on the sas file "OvCaFil;


option   nocenter  ls=110  ps=9999  notes;
OPTIONS  FORMCHAR="|----|+|---+=|-/\<>*";


data  OvCaFil;                    *** SAS file used by macro, defined by pointing the;
set   OvCaFil;                    *** macro parameter  &SAS_File  to  "OvCaFil";

      file print;

      if (_N_ eq 1) then do;
         put  "                                                                                      " /
              "                                       Oral                        Family             " /
              "                                    Contrac   # Live     Duratn    Histry         Abs " /
              "                                     aptive    Birth        HRT      BrCa        Risk " /
              "                                        Use   0= >=3   0=    0y   or OvCa        OvCa " /
              "          Currnt  Projct            0=  >1y   1= 1:2   1= < 10y    0=  no     Model 3 " /
              "    ID #     Age     Age      Race  1= 0,1y   2=   0   2= >=10y    1= yes          (%)" /
              "                                                                          " ;
      end;

      *** all variables below take on their SAS variable names, not their macro names;
      *** see SAS variable names defined in Step 1;

      if (_n_ le 1000) then  put

          subject_ID                  8.0

          entryage                    8.1
          exitage_o                   8.1

          Race                        3.0  "="
          CharRace                   $6.

          Invrs_OC_Modl               9.0
          Invrs_Parity_Modl           9.0
          Horm_Model                 11.0
          FHbreast_Model             10.0

          Absolute_Risk_Model3       12.4;

      if (mod(_n_, 2) eq 0) then put " ";


title3   "Listing of the first 1000 records in temporary sas system file  OvCaFil";
title4   "Further analysis based on the projected abs risk must be performed using the";
title5   "sas system file  OvCaFil  as well as using the SAS variables in  OvCaFil";
title6   " ";
run;


***       proc contents  data=OvCaFil  VARNUM position;
***       title3 "Ovarian cancer RR covariates and risk projections";
***       run;
