### R code from vignette source 'vignette.Rnw'

###################################################
### code chunk number 1: vignette.Rnw:11-12
###################################################
library(BSR)


###################################################
### code chunk number 2: vignette.Rnw:18-20
###################################################
f <- system.file("sampleData", "data.rda", package="BSR")
load(f)


###################################################
### code chunk number 3: vignette.Rnw:24-26
###################################################
train.data[1:5, 1:5]
test.data[1:5, 1:5]


###################################################
### code chunk number 4: vignette.Rnw:32-35
###################################################
response.var <- "y"
id.var       <- "id"
vars0        <- "intercept"


###################################################
### code chunk number 5: vignette.Rnw:40-42
###################################################
outdir <- getwd()
print(outdir)


###################################################
### code chunk number 6: vignette.Rnw:46-56
###################################################
groups <- list(
group1=c("x.1", "x.2"), 
group2=c("x.3", "x.4", "x.5"),
group3=paste("x.", 20:25, sep=""),
group4=paste("x.", 47:50, sep=""),
group5="x.40",
group6="x.41",
group7="x.42"
)
groups


###################################################
### code chunk number 7: vignette.Rnw:62-67
###################################################
interactions <- list(
c("group5", "group7", "group6"),
c("group3", "group1", "group2")
)
interactions


###################################################
### code chunk number 8: vignette.Rnw:71-87
###################################################
op.train <- list(
stepscale=1000, 
total_iteration=200000,
warm=20000,
savestep=50,
lowE=570,
maxE=670,
scale=1,
rho=1,
temperature=1,
maxvar=10,
maxbeta=10,
seed=10,
gamma=0.4,
model_maxn=100000,
delete=0)


###################################################
### code chunk number 9: vignette.Rnw:91-100
###################################################
op.resample <- list(
total_iteration=500000,
warm=2000,
savestep=10,
temperature=1,
seed=10,
model_maxn=100000,
delete=0
)


###################################################
### code chunk number 10: vignette.Rnw:104-108
###################################################
op.prediction <- list(n.burn=100)

op <- list(train.op=op.train, resample.op=op.resample, 
    prediction.op=op.prediction, out.string="_EXAMPLE")


###################################################
### code chunk number 11: vignette.Rnw:116-118
###################################################
#ret <- BSR(train.data, test.data, outdir, response.var, id.var, vars0,
#           groups=groups, interactions=interactions, op=op) 


###################################################
### code chunk number 12: vignette.Rnw:122-126
###################################################
f1 <- system.file("sampleData", "PREDICTION_EXAMPLE.TRAIN.txt.xls", package="BSR")
f2 <- system.file("sampleData", "PREDICTION_EXAMPLE.TEST.txt.xls", package="BSR")
mat.train <- read.table(f1, header=T, sep="\t")
mat.test  <- read.table(f2, header=T, sep="\t")


###################################################
### code chunk number 13: vignette.Rnw:130-135
###################################################
sum(abs(mat.train[,1]-mat.train[,3]))/nrow(mat.train)
sum(abs(mat.train[,2]-mat.train[,3]))/nrow(mat.train)

sum(abs(mat.test[,1]-mat.test[,3]))/nrow(mat.test)
sum(abs(mat.test[,2]-mat.test[,3]))/nrow(mat.test)


