### R code from vignette source 'vignette.Rnw'

###################################################
### code chunk number 1: start
###################################################
library(hsegHMM)


###################################################
### code chunk number 2: facets
###################################################
library(facets)


###################################################
### code chunk number 3: data file
###################################################
datafile <- system.file("sampleData", "facets_data.csv.gz", package="hsegHMM")


###################################################
### code chunk number 4: read
###################################################
tcga <- readSnpMatrix(datafile)


###################################################
### code chunk number 5: pre
###################################################
set.seed(2017)
xx <- preProcSample(tcga,ndepth=5)


###################################################
### code chunk number 6: process
###################################################
oo <- procSample(xx,cval=150)


###################################################
### code chunk number 7: logor
###################################################
inputs <- oo$jointseg[,11:12] 
lr <- inputs[,1]
logor <- inputs[,2]


###################################################
### code chunk number 8: thin
###################################################
idx_thin <- seq(1, length(lr), 30)
lr       <- lr[idx_thin]
logor    <- logor[idx_thin]


###################################################
### code chunk number 9: hsegHMM
###################################################
ret <- hsegHMM_T(lr, logor, purity=0.8, ploidy=1.5, logR.var=0.5,
                    logOR.var=0.5, df=3, stopTol=1)


###################################################
### code chunk number 10: geno
###################################################
gtype <- ret$genoStates
ctz0  <- ret$copyNumber


###################################################
### code chunk number 11: maxprob
###################################################
idx_hgtype <- ret$which.max.post.prob


###################################################
### code chunk number 12: copynumber
###################################################
hat_ctz    <- ctz0[idx_hgtype]


###################################################
### code chunk number 13: hatlrlogor
###################################################
hat_logr  <- ret$logR_hat
hat_logor <- ret$logOR_hat


###################################################
### code chunk number 14: plot
###################################################
par(mfrow=c(4,1))

plot(1:length(lr), lr, pch=20, col="blue", cex=0.5, 
  xlab="genetic location", cex.lab=1.5, ylab="logR")
points(1:length(hat_logr),hat_logr, pch=20, col="red", cex=0.5)

plot(1:length(logor), logor, pch=20, col="blue", ylab="logOR",
   cex.lab=1.5,xlab="genetic location",cex=0.5, 
   ylim=c(min(na.omit(logor)),max(na.omit(logor))))
points(1:length(hat_logor), hat_logor, pch=20,col="red", cex=0.5)
points(1:length(hat_logor), -hat_logor, pch=20,col="red", cex=0.5)

plot(1:length(hat_ctz), hat_ctz, pch=20, ylab="copy number",cex.lab=1.5,
  xlab="genetic location", ylim=c(0,max(hat_ctz)),col="red", cex=0.5)

plot(1:length(idx_hgtype), idx_hgtype-1, pch=20, ylab="",cex.lab=1.5, 
 xlab="genetic location",ylim=c(0,max(idx_hgtype-1)), yaxt="n",
 col="red", cex=0.5)
axis(2, at=c(0:max(idx_hgtype-1)), labels=gtype[1:max(idx_hgtype)], las=2) 


###################################################
### code chunk number 15: sessionInfo
###################################################
sessionInfo()


