function [s,l] = pexp(t,delta,w,knots)
%  MATLAB function for piecewise exponential survival estimation
%
% INPUT ARGUMENT (all vectors should be column vector)
%      t = time to event 
%  delta = 0-1 indicator of failure
%     w = vector of prior weights (assume 1 if no weights are needed)
%  knots = vector of knots for piecewise constant model of hazards 
%          (the first knot should not be smaller than the time of the first event
%           and the last knot should not be higher than the time of the last event)
%
% OUTPUT ARGUMENT
%      s=  (K+1) by 1 vector of survival probabilities (K=number of knots)
%      l = (K+1) by 1 vector of hazards (K=number of knots)

[d,py] = pyear(t,delta,knots);

knots=[0;knots;100000];
k=length(knots);
dw = d.*repmat(w,1,k-1);
pyw = py.*repmat(w,1,k-1);

sdw = (sum(dw,1))';
spyw = (sum(pyw,1))';
l=sdw./spyw;
l(sdw==0)=0;
cl=cumsum(l(1:(k-2)).*(knots(2:k-1)-knots(1:(k-2))));
s=exp(-cl);
