function y=bin2(x,endpt)
% Function for binning x values within specified break points
% Left endpoint included in the interval 
nint = length(endpt)-1;
[s,o]=order(x);
z=zeros(length(s),1);
j=1;
for i=1:length(s)
   found=0;
   if(s(i)<endpt(1)) %If less than first endpt assign missing
      z(i)=NaN;
   else   
         while j <= nint
            if s(i)<endpt(j+1) & s(i) >= endpt(j)
               z(i)=j;
               found=1;
               break;
            end
            j=j+1;
         end
         if found==0
            z(i)=NaN
         end   
    end
 end 
     y=z(o);


      