### R code from vignette source 'vignette.Rnw'

###################################################
### code chunk number 1: start
###################################################
library(TREAT)


###################################################
### code chunk number 2: data frame
###################################################
  set.seed(123)
  y     <- c(rep(0, 1000), rep(1, 1000))
  covar <- sample(0:2, 2000, replace=TRUE, prob=rep(1/3,3))
  SNPs  <- matrix(rbinom(2000*10, 2, c(.36, .48, .16)), nrow=2000)
  SNPs  <- as.data.frame(SNPs)
  colnames(SNPs) <- paste("rs", 1:10, sep="")
  data  <- data.frame(y, covar, SNPs)


###################################################
### code chunk number 3: TREAT
###################################################
tr <- treat(y ~ factor(covar), data = data, snp.vars = colnames(SNPs))


###################################################
### code chunk number 4: results1
###################################################
tr$adj.pval
tr$tree.model.forward


###################################################
### code chunk number 5: plink
###################################################
  bed <- system.file("sampleData", "data.bed", package="TREAT")
  bim <- system.file("sampleData", "data.bim", package="TREAT")
  fam <- system.file("sampleData", "data.fam", package="TREAT")


###################################################
### code chunk number 6: data
###################################################
  x <- read.table(fam, header=0, stringsAsFactors=FALSE)
  colnames(x) <- c("FAMILY", "SUBJECT", "FATHER", "MOTHER", "SEX", "Y")


###################################################
### code chunk number 7: gene object
###################################################
gene.obj <- rbind(c(8, 12799052, 12895289, "Gene1"), 
                    c(8, 12868315, 12989321, "Gene2"))
colnames(gene.obj) <- c("Chr", "Start", "Stop", "Gene")


###################################################
### code chunk number 8: treat.plink
###################################################
formula <- as.formula(Y ~ SEX)
id.vars <- c("FAMILY", "SUBJECT")
op <- list(thr.sample = 10, thr.leaf.size = 5)
tr <- treat.plink(c(bed, bim, fam), formula, x, id.vars, gene.obj, op=op)


###################################################
### code chunk number 9: output
###################################################
tr$summary
load(tr$saved.files["Gene1"])
obj$adj.pval
obj$tree.model.forward


###################################################
### code chunk number 10: sessionInfo
###################################################
sessionInfo()


