/*
    AARP_PLCO_EnCa_Model6_Template.sas                                      09/23/2013

    Short example on the use of the SAS macros  "AARP_PLCO_EnCa_RAM_Model6",
    Endometrial Cancer risk projection Model 6 based on the SAS EnCa RAM Model 5.1
    but includes the option of being able to project for African-American Abs Risk
    since African-American EnCa incidences and mortality are included.  However, the
    relative risks and attributable risks follow White women using the constants in
    SAS EnCa RAM Model 5.1.

    Step 1 is the creation and listing of a temporary sas system file (EnCaFil)
           from a raw file (EnCaFlat6.in) consisting of hypothetical women's
           Model 5 relative risk covariate information.

    Step 2 is the involking of the sas macro  AARP_PLCO_EnCa_RAM_Model6  to perform
           Model 6 risk projection based on EnCa Relative Risk Model 5 and
           White rates of 04/13/2012 as well as African-American rates of 09/17/2013.

    Step 3 is a simple post processing step.  The post processing is the listing of the
           temporary sas sytem file  (EnCaFil)  which contains the women's original
           relative risk covariate information as well as the appending of the
           projected absolute risk based on absolute risk projection model 6;
*/


option   nocenter  ls=110  ps=75  notes;
OPTIONS  FORMCHAR="|----|+|---+=|-/\<>*";


title1  'AARP_PLCO_EnCa_Model6_Template.sas, runs AARP_PLCO_EnCa_RAM_Model6     of  09/23/2013';


*** Step 1 Input raw relative risk covariate file  "EnCaFla36in"  and create a temporary
           sas system file with an arbitrary name say  "EnCaFil".
           The sas file  "EnCaFil"  is used in step 2 for input to the sas
           macro  AARP_PLCO_EnCa_RAM_RAM_Model6  which projects for absolute risk of EnCa

           if one already has a SAS file with the needed covariate information for the models,
           this step can be ignored and one can skip to Step 2;

data    EnCaFil;                              *** name of the sas system file which the macro parameter
                                                 &SAS_File  should point to upon macro invocation.
                                                  any arbitrary sas name can be used;

        infile 'EnCaFlat6.in'    FIRSTOBS=10; *** name of the raw  RR covariate input file (flat file)
                                                  any arbitrary sas name can be used

                                                  FIRSTOBS=10 skips the first 9 records of file header on
                                                  input file  'EnCaFlat6.in';


                *** SAS variable names for RR Model 5 RR covariates  any arbitrary sas name can be used

                    NOTE that all rr covariates  MUST BE RECODED  from their original values to
                         the integer value risk levels of  0,1,2...  used in the model;

            input   subject_ID

                    entryage
                    exitage

                    Cig_1
                    Cig_3

                    BMI5_cats

                    OC_Modl
                    Parity_Modl

                    Age_Meno_Pause
                    PreMenoPause_Ind

                    Horm_Model

                    Race;

            label subject_ID = "Unique ID number of woman";
run;




*** Step 2    Involking the sas macro AARP_PLCO_EnCa_RAM_Model6 to perform the EnCa projections.

              The temporary sas file is set to   "EnCaFil".

              The macro parameters  RelRsk and AbsRsk  points to the sas variables
                 Relative_Risk_Model5   and
                 Absolute_Risk_Model6
              which will be appended to the sas file  "EnCaFil";


%include     "AARP_PLCO_EnCa_RAM_Model6";           *** inclusion of the SAS macro
                                                        AAPR_PLCO_EnCa_RAM_Model6;

***                         Macro          pointing     SAS file name or
                            parameter      to           SAS variable name;

%AARP_PLCO_EnCa_RAM_Model6 (SAS_File                  = EnCaFil,

                            Woman_ID                  = Subject_ID,

                            T1                        = entryage,
                            T2                        = exitage,

                            OC_Model                  = OC_Modl,

                            AMeno                     = Age_Meno_Pause,
                            PMeno                     = PreMenoPause_Ind,

                            Parity_Model              = Parity_Modl,

                            Cig_1                     = Cig_1,
                            Cig_3                     = Cig_3,

                            BMI_Model                 = BMI5_cats,
                            Horm_Model                = Horm_Model,

                            HRT_Thin                  = Horm_ModelThin,

                            Race                      = Race,
                            CharRace                  = CharRace,

                            RelRsk                    = Relative_Risk_Model5,
                            AbsRsk                    = Absolute_Risk_Model6);



*** Step 3    List the contents of the temporary output sas system file  "EnCaFil"
              which contains the projected absolute risk as well as the relative risk
              covariate values.  Note that any further processing requiring the
              projected absolute risk, must be performed on the sas file "EnCaFil;

data  EnCaFil;                    *** SAS file used by macro, defined by pointing the;
set   EnCaFil;                    *** macro parameter  &SAS_File  to  "EnCaFil";

      file print;

      if (_N_ eq 1) then do;
         put "                                                     BMI                       Age of                                    "  /
             "                                                0=   <25                   Meno Pause          Duratn                    "  /
             "                                                1=[25,30)          Parity  0=  PreMen    Pre      HRT             AbsRisk"  /
             "                                   Non-  Formr  2=[30,35)      OC  0=  >2  or age<=49   Meno  0=   0y              EndoCa"  /
             "      ID  Currn   Proj            Smokr  Smokr  3=[35,40)  0= > 1  1= 1,2  1=   50:54  Pause  1= <10y    HRT *    Model 6"  /
             "       #    Age    Age      Race    Ind    Ind  4=  >=40   1= 0,1  2=   0  2=    >=55    Ind  2=  10y+  (BMI<25)       (%)" /
             " ";
      end;

      *** all variables below take on their SAS variable names, not their macro names;
      *** see SAS variable names defined in Step 1;
      if (SEQ_Num le 200) then  put

          subject_ID                  8.0

          entryage                    7.1
          exitage                     7.1

          Race                        3.0  "="
          CharRace                   $6.

          Cig_1                       7.0
          Cig_3                       7.0

          BMI5_cats                  10.0

          OC_Modl                     9.0
          Parity_Modl                 8.0

          Age_Meno_Pause             12.0
          PreMenoPause_Ind            7.0

          Horm_Model                  9.0
          Horm_ModelThin             10.0

          Absolute_Risk_Model6       10.4;

      if (mod(_n_, 2) eq 0) then put " ";


title3   "Listing of the first 200 records in temporary sas system file  EnCaFil";
title4   "Further analysis based on the projected abs risk must be performed using the";
title5   "sas system file  EnCaFil  as well as using the SAS variables in  EnCaFil";
title6   " ";
run;


***       *** proc contents  data=EnCaFil  VARNUM position;
***       *** title3 "Endometrial cancer RR covariates and risk projections";
***       *** run;

