/*
   AABrCa_example.sas                                                         09/30/10
   
   a sample sas program which obtains absolute risk of breast cancer for African-
   American Women with 95% confidence intervals by involking the SAS macro 
   AABrCa_RAM
   
   This sample sas program involves 2 steps:
   
   Step1:  Initially inputing from an ascii/flat file  "AfAM_RR.fil".  This file 
           contains race, relative risk and projection age variables. Upon the
           conclusion of Step1, a sas file  "AfAM_RR"  is created to be used for 
           input in Step2 to the sas macro  "AABrCa_RAM".
           
           In addition, a listing of all relevant variables in the sas file  
           "AfAM_RR"  is provided.  Note that the input file includes two covariates, 
           one which is AgeGe50 and the other which is AgeFstLive which are required 
           for white women abs risk projection but not for African-American women.  
           The listing excludes these two variables and only presents variables 
           relevant to African-American women.
           
   Step2: "Including" the sas macro  "AABrCa_RAM"  which is used for African-American
           Breast Cancer abs risk projection.  Once this macro is "included", the 
           program involkes it to project for African-American breast cancer absolute 
           risk by reading the sas file  "AfAM_RR".
           
           A listing of the resulting sas file  "AfAM_RRout"  which includes the 
           projected absolute risk, se of abs risk and 95% confidence interval as 
           well as the relevant variables.
*/

title1 'AfAMAbsRsk.sas:  Absolute risk projection of BrCa for African-American women';

options nocenter ls=86 ps=60 pageno=1 ;
options FORMCHAR="|----|+|---+=|-/\<>*";

*** Step1       Read the sample input ascii/flat data file  "AfAM_RR.fil"  and save  
                as a sas file  "AfAM_RR"  for input to the sas macro  "AABrCa_RAM".
                print the relevant variables for African-Americans;
                
data    AfAM_RR;                                       *** sas file needed for input
                                                           to the sas macro;

        infile "AfAM_RR.fil";                          *** input ascii/flat file;
        
        input   AgeGe50    Num_Biops   AgeMenarche   AgeFstLive   Num_Rels   HP     
                Race       Currn_Age   Projtn_Age    IDD;
run;


proc    print  data=AfAM_RR;                           *** print the input file;
ID      IDD;
var     Num_Biops  AgeMenarche  Num_Rels  HP   Race  
        Currn_Age  Projtn_Age;
run;



*** Step 2      Involking the sas macro AABrCa_RAM to perform the BrCa projections.

                The temporary sas input  file is set to   "AfAM_RR".
                The temporary sas output file is set to   "AfAM_RROut".

                The macro parameters  T1, T2, NBiops, HyprPlas, AgeMen,
                and NumRel point to their corresponding sas variables
                on the input sas file  "AfAM_RR",  namely
                Currn_Age, Projtn_Age, Num_Biops, HP, AgeMenarche and NumRel
                respectively.

                The macro parameters AbsRsk points to the sas variable Absolute_Risk,
                se_AbsRsk points to SE_AbsolutRsk, Lo_95CI points to Lower_95CI and 
                Hi_95CI points to Highr_95CI which will be added to the output sas   
                file  "AfAM_RROut".  
                
                The output sas file  "AfAM_RROut"  will also contain all the relevant 
                relative risk variables required by the sas macro  "AABrCa_RAM"; 
                


%include  "AABrCa_RAM";               *** Including  AABrCa_RAM  SAS macro here.
                                          If you want the SAS macro to be in-line with 
                                          this program, copy  the file  AABrCa_RAM  here;

            *** Required    
                Macro          pointing      SAS file name or
                parameters     to            SAS variable name;

%AABrCa_RAM    (In_File        =             AfAM_RR      ,
                Out_File       =             AfAM_RROut   ,

                T1             =             Currn_Age    ,
                T2             =             Projtn_Age   ,

                NBiops         =             Num_Biops    ,
                HyprPlas       =             HP           ,

                AgeMen         =             AgeMenarche  ,
                NumRel         =             Num_Rels     ,
                
                Race           =             Race,

                AbsRsk         =             Absolute_Risk,
                se_AbsRsk      =             SE_AbsolutRsk,
                Lo_95CI        =             Lower_95CI,
                Hi_95CI        =             Upper_95CI,
                
                Error_Ind      =             Error_Ind,
                IDD            =             IDD);


                
options nocenter ls=86 ps=60 pageno=1 ;
options FORMCHAR="|----|+|---+=|-/\<>*";

proc    print  data=AfAM_RROut;                        *** print the output sas file;
id      IDD;
var     Num_Biops  HP  AgeMenarche  Num_Rels    Currn_Age  Projtn_Age  Absolute_Risk    
        SE_AbsolutRsk  Lower_95CI   Upper_95CI  Error_Ind  Race;

title3 "AfAM_RROut   SAS file with African-American Women RR covariates,";
title4 "             projected Absolute Risk and 95% CI";
run;
