/*
    Men_CRC_Template_agerange4090.sas                                        01/30/19
 
    Men_CRC_Template.sas                                                     06/02/15

    Short example on the use of the SAS macro   "Men_CRC_RAM"   consisting
    of 3 steps

    Colorectal Cancer Relative Risk Model absolute risk projection:

    Step 1 is the creation of a temporary sas system file (named  CRC_Fil)
           from a raw input file (Men_CRC_raw.in) consisting of 437 hypothetical
           men's CRC relative risk covariate patterns

    Step 2 involking the sas macro  Men_CRC_RAM  to perform risk projections

    Step 3 simple post processing step.  The post processing is the listing of the
           temporary sas sytem file  (CRC_Fil)  which contains the men's original
           relative risk covariate information as well as the projected absolute risk
*/


option   nocenter  ls=102  ps=60   notes;
option   FORMCHAR="|----|+|---+=|-/\<>*";


/* Men's Colorectal Cancer Abs Risk Projection sample program involking  Men_CRC_RAM  */

title1  'Men_CRC_Template_agerange4090.sas:  sample sas program utilizing sas macro Men_CRC_RAM_agerange4090';
title2  '                       to obtain absolute risk projection of Men CRC';
title3  ' ';


*** Step 1 Input raw relative risk RR covariate input file  "Men_CRC_raw.in"  and
           create a temporary sas system file with an arbitrary name say  "CRC_Fil".
           The sas file  "CRC_Fil"  is used in step 2 for input to the sas
           macro  Men_CRC_RAM  which projects for absolute risk of Colorectal Cancer

           if one already has a SAS file with the needed covariate information, this step
           can be ignored and one can proceed directly to Step 2;


data    CRC_Fil;                 *** name of the sas system file which the macro parameter
                                    'SAS_File'   points to upon macro invocation.
                                     Any arbitrary sas file name can be used;

        infile 'Men_CRC_Raw.in'
                FIRSTOBS=13;     *** name of RR covariate input file (flat file)
                                     again, any abrbitray file name can be used;

        ***     SAS variable names for RR covariates.  any variable name can be used.
                see first 150 lines  Men_CRC_RAM  for covariate definition;
        input   ID_Num

                ethnicity
                currnAge
                projnAge

                Sigmoid_Colonscopy_Polyp
                HrsExercise
                VegLT5_Ind

                Cig_Yrs
                Num_Cigs

                BMI_Trend
                NumRel_012

                NoIBuprofen
                NoNSAIDS;
run;


*** Step 2    code to /prj/bb/BBSTAT/pfeiffer/CCRAT/progs/SAS/update/Men_CRC_RAM_agerange4090  into the sas program stream;

                                         ***************************************************;
                                         ***************************************************;
                                         ***                                             ***;
%include     "Men_CRC_RAM_agerange4090"; *** inclusion of the SAS macro  Men_CRC_RAM     ***;
                                         ***                                             ***;
                                         *** this line of code is used by sas to insert  ***;
                                         *** the sas macro  Men_CRC_RAM  into program    ***;
                                         *** stream so it's available for the next line  ***;
                                         *** of code.                                    ***;
                                         ***                                             ***;
                                         *** 3 methods so sas can resolve  Men_CRC_RAM   ***;
                                         ***                                             ***;
                                         *** (1) include copy of     Men_CRC_RAM  in the ***;
                                         ***     file folder of sas program  which is    ***;
                                         ***     involking the sas macro  Men_CRC_RAM    ***;
                                         ***                                             ***;
                                         *** (2) delete this line of code and replace    ***;
                                         ***     it with a copy of    Men_CRC_RAM        ***;
                                         ***                                             ***;
                                         *** (3) if  Men_CRC_RAM  is stored in a         ***;
                                         ***     different folder from where it is being ***;
                                         ***     involked, then the fully qualified path ***;
                                         ***     must be included within quoatation      ***;
                                         ***     marks e.g.  "c:\sas_macro\Men_CRC_RAM"  ***;
                                         ***                                             ***;
                                         ***************************************************;
                                         ***************************************************;

***           code to involke sas macro  Men_CRC_RAM  and perform the Colorectal Ca projection

              the temporary sas file is set to   "CRC_Fil"

              the macro parameter  AbsRsk  points to the sas variable  Absolute_Risk
              which will be appended to the sas file  "CRC_Fil";

***                             Macro          pointing       SAS file name or;
***                             parameter      to             SAS variable name;

%Men_CRC_RAM                   (SAS_File                    = CRC_Fil,

                                ID_Num                      = ID_Num,

                                Race                        = ethnicity,
                                T1                          = currnAge,
                                T2                          = projnAge,

                                Sigmoid_Polyps              = Sigmoid_Colonscopy_Polyp,
                                NoIBuprofen                 = NoIBuprofen,
                                Vigorus_Xrcis               = HrsExercise,

                                Cig_Yrs                     = Cig_Yrs,
                                Vegetable                   = VegLT5_Ind,
                                Num_Cigs                    = Num_Cigs,

                                BMI_Trnd                    = BMI_Trend,
                                No_NSaids                   = NoNSAIDS,
                                Fam_Hist_CRC                = NumRel_012,

                                PattrnNumber                = Pattrn_ID,
                                AbsRsk                      = Absolute_Risk);


*** Step 3    List the contents of the temporary output sas system file  "CRC_Fil"
              which contains the projected absolute risk as well as the relative risk
              covariate values.  Note that any further processing requiring the
              projected absolute risk, must be performed on the sas file "CRC_Fil";

option  nocenter  ls=140  ps=20000  notes;

data    CRC_Fil;                  *** SAS file used by macro, defined by pointing the;
set     CRC_Fil;                  *** macro parameter  &SAS_File  to  "CRC_Fil";

        array  Races (irace)  $ race1  race2  race3  race4  unk_race
       ("   White",  "   Black",  "  Hspanc",  "   Asian", "       .");

                                    irace = ethnicity;
        if (ethnicity ne 1 and
            ethnicity ne 2 and
            ethnicity ne 3 and
            ethnicity ne 4)    then irace = 5;      *** indexes Races to missing value .;

        SEQ_Num          =             _n_;
        Revrse_hrsXrcise = 3 - HrsExercise;               *** reversing the polarity of # of hrs vigorous exercise;


        *** all variables below take on their SAS variable names, not their macro names;
        *** see SAS variable names defined in Step 1;
        file print;

        if      (Seq_Num  eq  1) then do;
            /*
            put "                                                                                                                         ";
            put "       RelRsk                Sigmoid  #  Hrs  Vgtabl                                         TakNSaid TakeNSaid          ";
            put "    ID Pattrn                 Colysc  Vigors  servng         #          #       BMI    #Rel  nonAsprn  Aspirn or     Abs ";
            put "     #     ID Race T1 T2      Polyps  Xrcise  per wk   Cig Yrs   Cigarets     Trend     CRC  IBuprofn? IBuprofn?   Rsk(%)";
            put "                                                                                                                         ";
            put "                                                      0= -9,0    0= -9,0                                                 ";
            put "                         0=y, n poly                  1=( 0,15)  1=[ 1,11)           0=-9,0                              ";
            put "                         1=n          0= 0            2=[15,35)  2=[11,20]           1=-8,1  yes=-9,0  yes=-9,0          ";
            put "                         2=y, y poly  1=(0,2]         3=  >=35   3=  >=21  0=   <25  2=  >1   no=   1   no=   1          ";
            put "                         3=uk,ukpoly  2=(2,4]  0=ge5     -9 is      -9 is  1=[25,30)  -8,-9        -9        -9          ";
            put "                          =y, ukpoly  3=  >4   1= <5  dontknow   dontknow  2= ge 30  dntknw  dontknow  dontknow          ";
            put "                                                                                                                         ";
            put "                                                                                                                         ";
            */

            put "      RelRsk                Sigmoid  #  Hrs  Vgtabl                                         TakNSaid TakeNSaid           ";
            put "   ID Pattrn                 Colysc  Vigors  servng         #          #       BMI    #Rel  nonAsprn  Aspirn or   Abs    ";
            put "    #     ID Race T1 T2      Polyps  Xrcise  per wk   Cig Yrs   Cigarets     Trend     CRC  IBuprofn? IBuprofn?   Risk(%)";
            put "                                                                                                                         ";
            put "                                                      0= -9,0    0= -9,0                                                 ";
            put "                         0=y, n poly                  1=( 0,15)  1=[ 1,11)           0=-9,0                              ";
            put "                         1=n          0= 0            2=[15,35)  2=[11,20]           1=-8,1  yes=-9,0  yes=-9,0          ";
            put "                         2=y, y poly  1=(0,2]         3=  >=35   3=  >=21  0=   <25  2=  >1   no=   1   no=   1          ";
            put "                         3=uk,ukpoly  2=(2,4]  0=ge5     -9 is      -9 is  1=[25,30)  -8,-9        -9        -9          ";
            put "                          =y, ukpoly  3=  >4   1= <5  dontknow   dontknow  2= ge 30  dntknw  dontknow  dontknow          ";
            put "                                                                                                                         ";



        end;

        if (Pattrn_ID ne .) then do;

              if (mod(SEQ_Num,4) eq 1) then put  " ";

              put  ID_Num                        5.0
                   Pattrn_ID                     7.0

                   Races                    $CHAR4.
                   currnAge                      4.0
                   projnAge                      3.0

                   Sigmoid_Colonscopy_Polyp     13.0
                   HrsExercise                   8.0

                   VegLT5_Ind                    8.0
                   Cig_Yrs                      10.0
                   Num_Cigs                     11.0

                   BMI_Trend                    10.0
                   NumRel_012                    8.0
                   NoIBuprofen                  10.0
                   NoNSAIDS                     10.0
                   Absolute_Risk                 9.4;
        end;

title3  " ";
title4  "Listing of records in temporary sas system file  CRC_Fil";
title5  "Further analysis based on the projected abs risk must be performed using  CRC_Fil";
title6  " ";
run;


proc print data=CRC_Fil;
run;

proc export data = CRC_Fil
  outfile ='/prj/bb/BBSTAT/pfeiffer/CCRAT/progs/SAS/update/Men_CRC_Template_agerange4090_newrates_test_out.csv'
  dbms = csv replace;
run;
