/*
    Women_CRC_Template_agerange4090.sas                                        01/30/19
    Women_CRC_Template.sas   Ver 2                                             06/09/15
    Women_CRC_Template.sas   Ver 1                                             05/14/10

    Short example on the use of the SAS macro  "Women_CRC_RAM_agerange4090"  consisting
    of 3 steps

    Colorectal Cancer Relative Risk Model absolute risk projection:

    Step 1 is the creation of a temporary sas system file (CRC_Fil)
           from a raw file (Women_CRC_raw.in) consisting of 768 hypothetical women's
           relative risk covariate information (all 768 admissible covariate patterns)

    Step 2 involking the sas macro  Women_CRC_RAM  to perform risk projections

    Step 3 simple post processing step.  The post processing is the listing of the
           temporary sas sytem file  (CRC_Fil)  which contains the women's original
           relative risk covariate information as well as the projected absolute risk
*/


option   nocenter  ls=100  ps=60   notes;
option   FORMCHAR="|----|+|---+=|-/\<>*";


/*  Colorectal Cancer Abs Risk Projection sample program based on Women_CRC_RAM_agerange4090 */

title1  'Women_CRC_Template_agerange4090.sas:  sample sas program utilizing sas macro  Women_CRC_RAM';
title2  '                         to obtain absolute risk projection of Women CRC';
title3  ' ';

*** Step 1 Input raw relative risk covariate file  "Women_CRC_raw.in"  and create a
           temporary sas system file with an arbitrary name say  "CRC_Fil".
           The sas file  "CRC_Fil"  is used in step 2 for input to the sas
           macro  Women_CRC_RAM  which projects for absolute risk of Colorectal Cancer

           if one already has a SAS file with the needed covariate information this step
           can be ignored and one can proceed to Step 2;


data    CRC_Fil;                  *** name of the sas system file which the macro parameter
                                      &SAS_File  points to upon macro invocation.
                                      any arbitrary sas file name can be used;

        infile 'Women_CRC_raw.in'
                firstobs=14;      *** name of RR covariate input file (flat file)
                                      again, any abrbitray file name can be used;

                *** SAS variable names for RR covariates.  any variable name can be used.
                    see first 100 lines  Women_CRC_RAM  for covariate definition;

            input   ID_Num

                    ethnicity
                    currnAge
                    projnAge

                    Sigmoid_Colonscopy_Polyp
                    Estrogen_Status
                    Family_History_CRC

                    Aspirin_NSAIDS
                    Exercise
                    Body_Mass_Index

                    Vegetable_Intake;
run;


*** Step 2    code to /prj/bb/BBSTAT/pfeiffer/CCRAT/progs/SAS/update/Women_CRC_RAM_agerange4090 into the sas program stream;

                                          ***************************************************;
                                          ***************************************************;
                                          ***                                             ***;
%include     "Women_CRC_RAM_agerange4090";*** inclusion of the SAS macro  Women_CRC_RAM   ***;
                                          ***                                             ***;
                                          *** this line of code is used by sas to insert  ***;
                                          *** the sas macro  Women_CRC_RAM  into program  ***;
                                          *** stream so it's available for the next line  ***;
                                          *** of code.                                    ***;
                                          ***                                             ***;
                                          *** 3 methods so sas can resolve  Women_CRC_RAM ***;
                                          ***                                             ***;
                                          *** (1) include copy of  Women_CRC_RAM  in the  ***;
                                          ***     file folder of sas program  which is    ***;
                                          ***     involking the sas macro  Women_CRC_RAM  ***;
                                          ***                                             ***;
                                          *** (2) delete this line of code and replace    ***;
                                          ***     it with a copy of  Women_CRC_RAM        ***;
                                          ***                                             ***;
                                          *** (3) if  Women_CRC_RAM  is stored in a       ***;
                                          ***     different folder from where it is being ***;
                                          ***     involked, then the fully qualified path ***;
                                          ***     must be included within the quoatation  ***;
                                          ***     marks e.g  "c:\sas_macro\Women_CRC_RAM" ***;
                                          ***                                             ***;
                                          ***************************************************;
                                          ***************************************************;

***           code to involke sas macro  Women_CRC_RAM  and perform the Colorectal Ca projection

              the temporary sas file is set to   "CRC_Fil"

              the macro parameter  AbsRsk  points to the sas variable  Absolute_Risk
              which will be appended to the sas file  "CRC_Fil";

***                             Macro          pointing       SAS file name or;
***                             parameter      to             SAS variable name;


%Women_CRC_RAM                 (SAS_File                    = CRC_Fil,

                                Race                        = ethnicity,
                                T1                          = currnAge,
                                T2                          = projnAge,

                                Sigmoid_Polyps              = Sigmoid_Colonscopy_Polyp,
                                Estrogen                    = Estrogen_Status,
                                Fam_Hist_CRC                = Family_History_CRC,

                                NSaids                      = Aspirin_NSAIDS,
                                Vigorus_Xrcis               = Exercise,
                                BMI                         = Body_Mass_Index,

                                Vegetable                   = Vegetable_Intake,

                                AbsRsk                      = Absolute_Risk);



*** Step 3    List the contents of the temporary output sas system file  "CRC_Fil"
              which contains the projected absolute risk as well as the relative risk
              covariate values.  Note that any further processing requiring the
              projected absolute risk, must be performed on the sas file "CRC_Fil";

option   nocenter  ls=130  ps=6000  notes;

data  CRC_Fil;                  *** SAS file used by macro, defined by pointing the;
set   CRC_Fil;                  *** macro parameter  &SAS_File  to  "CRC_Fil";

      array  Races (irace)  $ race1  race2  race3  race4  unk_race
     ("W",  "B",  "H",  "A", ".");

                                  irace = ethnicity;
      if (ethnicity ne 1 and
          ethnicity ne 2 and
          ethnicity ne 3 and
          ethnicity ne 4)    then irace = 5;      *** indexes Races to missing value .;

      file print;

      SEQ_Num        = _n_;

      Revrse_Xrcise  = 3 - Exercise;                 *** change the polarity of the exercise covariate;

      tmp_AsprnNSaid = Aspirin_NSAIDS;
      if (tmp_AsprnNSaid eq -9) then tmp_AsprnNSaid = 0;

      tmp_Estrogen   = Estrogen_Status;
      if (tmp_Estrogen   eq -9) then tmp_Estrogen   = 0;

      tmp_FamHist    = Family_History_CRC;
      if (tmp_FamHist    eq -9) then tmp_FamHist    = 0;
      if (tmp_FamHist    eq -8) then tmp_FamHist    = 1;


      Pattern_ID     =   (tmp_FamHist+1)             +
                       3*(tmp_AsprnNSaid)            +
                     2*3*(Sigmoid_Colonscopy_Polyp)  +
                   4*2*3*(Body_Mass_Index)           +
                 2*4*2*3*(Vegetable_Intake)          +
               2*2*4*2*3*(tmp_Estrogen)              +
             2*2*2*4*2*3*(Revrse_Xrcise);



      *** all variables below take on their SAS variable names, not their macro names;
      *** see SAS variable names defined in Step 1;
***   if (SEQ_Num le 100) then do;

          if (SEQ_Num  eq  1) then do;
             put "                                 Sigmod   Strogn        Nsaids/                  Vegtable          ";
             put "                                 Colysc   Trtmnt  #Rel  Asprin   3- Hrs            Servng/         ";
             put "                                 Polyps  Last2yr   CRC     Use   Xrcise      BMI     Week          ";
             put " ";
             put "                            0= y,n poly           0=-9,                                            ";
             put "               R            1= n                     0           0= > 4                            ";
             put "      RelRsk   a            2= y,y poly    0=yes, 1=-8,  0=use,  1=(2,4]                           ";
             put "  ID  Pattrn   c            3=uk,ukpoly,      -9     1      -9   2=(0,2]  0=lt30    0=ge5    Abs   ";
             put "   #      ID   e   T1  T2      y,ukpoly    1= no  2= 2+  1= no   3= 0     1=ge30    1=lt5   Risk(%)";
             put " ";
          end;
          else if (mod(SEQ_Num,4) eq 1) then put " ";

          put

          ID_Num                      4.0
          Pattern_ID                  8.0
          "   "
          Races                  $CHAR1.
          currnAge                    5.0
          projnAge                    4.0

          Sigmoid_Colonscopy_Polyp   14.0
          Estrogen_Status             9.0
          Family_History_CRC          6.0
          Aspirin_NSAIDS              8.0
          Revrse_Xrcise               9.0
          Body_Mass_Index             9.0
          Vegetable_Intake            9.0

          Absolute_Risk               9.4;
***   end;

title3   ' ';
title4   "Listing of records in temporary sas system file  CRC_Fil";
title5   "Further analysis based on the projected abs risk must be performed using  CRC_Fil";
title6   ' ';
run;

proc print data=CRC_Fil;
run;

proc export data = CRC_Fil
  outfile ='/prj/bb/BBSTAT/pfeiffer/CCRAT/progs/SAS/update/Women_CRC_Template_agerange4090_newrates_test_out.csv'
  dbms = csv replace;
run;
