### R code from vignette source 'vignette.Rnw'

###################################################
### code chunk number 1: start
###################################################
library(BaDGE)


###################################################
### code chunk number 2: load data
###################################################
data(x, package="BaDGE")
x[1:5, ]
dim(x)


###################################################
### code chunk number 3: snps
###################################################
snps <- paste("SNP_", 1:15, sep="")
geno.mat <- x[, snps]
ret <- define.NB.geno(geno.mat)


###################################################
### code chunk number 4: define.NB.geno
###################################################
data(ret, package="BaDGE")


###################################################
### code chunk number 5: table
###################################################
table(ret$grp.subj, exclude=NULL)


###################################################
### code chunk number 6: add group
###################################################
x[, "Group"] <- ret$grp.subj


###################################################
### code chunk number 7: outdir
###################################################
outdir <- system.file("sampleData", package="BaDGE")


###################################################
### code chunk number 8: options
###################################################
op <- list(sim.mat=ret$NB.mat, n_iter=200000, n_sep_out=100, w_m=50, k_max=2,
           alpha_min=-3, alpha_max=3, beta_min=-3, beta_max=3)


###################################################
### code chunk number 9: trans
###################################################
# Not run to save time
#badge(x, "Disease", "Exposure", "Group", outdir, op=op) 


###################################################
### code chunk number 10: post options
###################################################
op$M1 <- 100


###################################################
### code chunk number 11: post process
###################################################
ret <- post_badge(geno.mat, x, "Disease", "Exposure", "Group", outdir, op=op) 
names(ret)


###################################################
### code chunk number 12: options 2
###################################################
op$num_iter <- 1000000


###################################################
### code chunk number 13: run_SAMC
###################################################
#run_SAMC(x, "Disease", "Exposure", "Group", outdir, op=op) 


###################################################
### code chunk number 14: options 3
###################################################
op$method_psi <- 2
op$psi_file <- paste(outdir, "/psi_grid_2.txt", sep="")


###################################################
### code chunk number 15: psi file
###################################################
read.table(op$psi_file, header=0)


###################################################
### code chunk number 16: trans 2
###################################################
op$out.string <- "PSI2."
#badge(x, "Disease", "Exposure", "Group", outdir, op=op) 


###################################################
### code chunk number 17: post process
###################################################
ret <- post_badge(geno.mat, x, "Disease", "Exposure", "Group", outdir, op=op) 


###################################################
### code chunk number 18: sessionInfo
###################################################
sessionInfo()


