function [d,py] = pyear(t,delta,knots)
% MATLAB function for computing life tables from survival data 
%
% INPUT ARGUMENT (all vectors should be column vector)
%      t = time to event 
%  delta = 0-1 indicator of events
%  knots = vector of knots for defining age intervals
%          (the first knot should not be smaller than the time of the first event
%           and the last knot should not be higher than the time of the last event)
%
% OUTPUT ARGUMENT
%  d = N by (K+1) table of events (N=number of subjects, K=number of knots)
%  py = N by (K+1) table of person-years (N=number of subjects, K=number of knots)

% Add zeros and infinity into the knots
knots=[0;knots;100000];
k=length(knots);
n=length(t);

py = zeros(n,k-1);
d = zeros(n,k-1);

tc = bin2(t,knots);

for(i = 2:k)
   py(:,(i-1))=knots(i)-knots(i-1);
   py(tc<(i-1),(i-1))=0;
   py(tc==(i-1),(i-1))=t(tc==(i-1))-knots(i-1)+0.5;
   d((delta==1)&(tc==i-1),(i-1))=1;
end

