/*
   M:\Sas.Progs\HispBrCa_AbsRisk\HispBrCaRAM_example.sas        7/18/2015

   program to model breast cancer relative risk from a hispanic data set
   based on modified/updated definition of Age Fst Live Birth covariate
   where nulliparous is grouped with age at first live birth is 30+

   using  SAS macro  HispBrCa_RAM_Ver2_1  based on the above modfied model
*/

OPTIONS  nocenter  ls=109  ps=60  pageno=1;
OPTIONS  formchar="|----|+|---+=|-/\<>*";

title1  "m:\sas.progs\hispbrca_absrisk\HispBrCaRAM_example.sas";

data    ExampleIn;             *** name of the sas system file which the macro parameter
                                  &In_File  should point to upon macro invocation;

        infile 'Sample.in'   firstobs=10;       *** "Sample.in"  is the RR covariate input file
                                                     firstobs=10  skips first 9 header
                                                     records on input file  "Sample.in";
            *** SAS variable names;

        input   IDD

                Age
                AgeProj

                NBiop
                HP

                AgeMenarchy
                AgeFstLive
                Num_Rels

                USborn;
run;


%include   "HispBrCa_RAM_Ver2_1";                                           *** this line of code inserts the SAS Macro
                                                                                HispBrCa_RAM_Ver2_1 at this point.  So that
                                                                                in the next line, when you invoke the
                                                                                SAS Macro  HispBrCa_RAM_Ver2_1,  it will be
                                                                                found and used;

%HispBrCa_RAM_Ver2_1 (In_File         = ExampleIn,
                      Out_File        = ExampleOut,

                      NumBoots        = 10000,

                      WID             = IDD,

                      T1              = Age,
                      T2              = AgeProj,

                      Biopsy          = NBiop,
                      HyperP          = HP,
                      AgeMen          = AgeMenarchy,
                      Age1st          = AgeFstLive,
                      FstRels         = Num_Rels,

                      US_Born         = USborn,

                      RR_Star1        = RR_Star1,
                      RR_Star2        = RR_Star2,

                      AbsRsk          = AbsoluteRisk,
                      LowrCL          = LowrCL,
                      UpprCL          = UpprCL,
                      SD_AR           = SD_AR);



*** Step 3    List the contents of the temporary output sas system file  "ExampleOut"
              which contains the projected absolute risk as well as the relative risk
              covariate values.  Note that any further processing requiring the
              projected absolute risk, must be performed on the output sas system file;

data  ExampleOut;                  *** output file from macro, defined by pointing the;
set   ExampleOut;                  *** macro parameter  &Out_File  to  "ExampleOut";

      file print;

      if (_N_ eq 1) then do;
         put "                                                           ";
         put "     ID                 #  Hypr    HP  Age  Age    #  USBrn"
             "        RR        RR   AbsRisk        SD   AbsRisk   AbsRisk";
         put "      #    T1    T2  Biop  plas    RR  Men  1st  Rel    Ind"
             "    Age<50   Age>=50        (%)  AbsRisk   Lo95%CL   Hi95%CL";

         put " ";
      end;

      *** all variables below take on their SAS variable names, not their macro names;
      *** see SAS variable names defined in Step 1;

      if (_n_ le 5000) then

         put IDD                  7.0
             Age                  6.1
             AgeProj              6.1

             NBiop                6.0
             HP                   6.0
             R_Hyp                6.2

             AgeMenarchy          5.0
             AgeFstLive           5.0
             Num_Rels             5.0

             USborn               7.0

             RR_Star1            10.4
             RR_Star2            10.4

             AbsoluteRisk        10.4
             SD_AR               10.5
             LowrCL              10.4
             UpprCL              10.4;


title3   "Listing of the first 5000 records in temporary output sas system file  HispBCout";
title5   "If the # of bootstrap replications is eqaul  to        0,  only absrisk is provided";
title6   "If the # of bootstrap replications is less than     1000,  95%CI from normal theory";
title7   "If the # of bootstrap replications is greater equal 1000,  95%CI from bootstrap DF";
run;


proc    sort data=ExampleOut;
by      USborn;
run;

title2 " ";


proc    means  data=ExampleOut  n  mean  std  min  max  median;
var     AbsoluteRisk;
run;

proc    means  data=ExampleOut  n  mean  std  min  max  median;
var     AbsoluteRisk;
by      USborn;

run;

